package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type DisplayWeatherForecastAppRoute struct {
	AppRoute                        *route.AppRoute
	AppUrler                        *urlers.AppUrler
	DisplayWeatherForecastAppBinder *binders.DisplayWeatherForecastAppBinder
	DisplayWeatherForecastMae       *mae.DisplayWeatherForecastMae
	DisplayWeatherForecastView      *html_views.DisplayWeatherForecastView
	Logger                          *logger.Logger
}

func (this *DisplayWeatherForecastAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.DisplayWeatherForecastMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.DisplayWeatherForecastAppBinder.Bind(c, in, c)
	out, errMae := this.DisplayWeatherForecastMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.DisplayWeatherForecastView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *DisplayWeatherForecastAppRoute) GetRoutePath() string {
	return "display-weather-forecast"
}
func (this *DisplayWeatherForecastAppRoute) GetMethod() string {
	return "GET"
}
