package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditGardenAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	EditGardenAppBinder *binders.EditGardenAppBinder
	EditGardenMae       *mae.EditGardenMae
	EditGardenView      *html_views.EditGardenView
	Logger              *logger.Logger
}

func (this *EditGardenAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.EditGardenMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.EditGardenAppBinder.Bind(c, in, c)
	out, errMae := this.EditGardenMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.EditGardenView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *EditGardenAppRoute) GetRoutePath() string {
	return "edit-garden"
}
func (this *EditGardenAppRoute) GetMethod() string {
	return "GET"
}
