package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditGardenTaskAppRoute struct {
	AppRoute                *route.AppRoute
	AppUrler                *urlers.AppUrler
	EditGardenTaskAppBinder *binders.EditGardenTaskAppBinder
	EditGardenTaskMae       *mae.EditGardenTaskMae
	EditGardenTaskView      *html_views.EditGardenTaskView
	Logger                  *logger.Logger
}

func (this *EditGardenTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.EditGardenTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.EditGardenTaskAppBinder.Bind(c, in, c)
	out, errMae := this.EditGardenTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.EditGardenTaskView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *EditGardenTaskAppRoute) GetRoutePath() string {
	return "edit-garden-task"
}
func (this *EditGardenTaskAppRoute) GetMethod() string {
	return "GET"
}
