package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditPlantAppRoute struct {
	AppRoute           *route.AppRoute
	AppUrler           *urlers.AppUrler
	EditPlantAppBinder *binders.EditPlantAppBinder
	EditPlantMae       *mae.EditPlantMae
	EditPlantView      *html_views.EditPlantView
	Logger             *logger.Logger
}

func (this *EditPlantAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.EditPlantMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.EditPlantAppBinder.Bind(c, in, c)
	out, errMae := this.EditPlantMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.EditPlantView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *EditPlantAppRoute) GetRoutePath() string {
	return "edit-plant"
}
func (this *EditPlantAppRoute) GetMethod() string {
	return "GET"
}
