package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditPlantTaskAppRoute struct {
	AppRoute               *route.AppRoute
	AppUrler               *urlers.AppUrler
	EditPlantTaskAppBinder *binders.EditPlantTaskAppBinder
	EditPlantTaskMae       *mae.EditPlantTaskMae
	EditPlantTaskView      *html_views.EditPlantTaskView
	Logger                 *logger.Logger
}

func (this *EditPlantTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.EditPlantTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.EditPlantTaskAppBinder.Bind(c, in, c)
	out, errMae := this.EditPlantTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.EditPlantTaskView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *EditPlantTaskAppRoute) GetRoutePath() string {
	return "edit-plant-task"
}
func (this *EditPlantTaskAppRoute) GetMethod() string {
	return "GET"
}
