package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditPlantationAppRoute struct {
	AppRoute                *route.AppRoute
	AppUrler                *urlers.AppUrler
	EditPlantationAppBinder *binders.EditPlantationAppBinder
	EditPlantationMae       *mae.EditPlantationMae
	EditPlantationView      *html_views.EditPlantationView
	Logger                  *logger.Logger
}

func (this *EditPlantationAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.EditPlantationMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.EditPlantationAppBinder.Bind(c, in, c)
	out, errMae := this.EditPlantationMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.EditPlantationView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *EditPlantationAppRoute) GetRoutePath() string {
	return "edit-plantation"
}
func (this *EditPlantationAppRoute) GetMethod() string {
	return "GET"
}
