package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditSeedProgramAppRoute struct {
	AppRoute                 *route.AppRoute
	AppUrler                 *urlers.AppUrler
	EditSeedProgramAppBinder *binders.EditSeedProgramAppBinder
	EditSeedProgramMae       *mae.EditSeedProgramMae
	EditSeedProgramView      *html_views.EditSeedProgramView
	Logger                   *logger.Logger
}

func (this *EditSeedProgramAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.EditSeedProgramMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.EditSeedProgramAppBinder.Bind(c, in, c)
	out, errMae := this.EditSeedProgramMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.EditSeedProgramView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *EditSeedProgramAppRoute) GetRoutePath() string {
	return "edit-seed-program"
}
func (this *EditSeedProgramAppRoute) GetMethod() string {
	return "GET"
}
