package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type EditUserAppRoute struct {
	AppRoute          *route.AppRoute
	AppUrler          *urlers.AppUrler
	EditUserAppBinder *binders.EditUserAppBinder
	EditUserMae       *mae.EditUserMae
	EditUserView      *html_views.EditUserView
	Logger            *logger.Logger
}

func (this *EditUserAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.EditUserMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.EditUserAppBinder.Bind(c, in, c)
	out, errMae := this.EditUserMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.EditUserView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *EditUserAppRoute) GetRoutePath() string {
	return "edit-user"
}
func (this *EditUserAppRoute) GetMethod() string {
	return "GET"
}
