package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type HomeAppRoute struct {
	AppRoute      *route.AppRoute
	AppUrler      *urlers.AppUrler
	HomeAppBinder *binders.HomeAppBinder
	HomeMae       *mae.HomeMae
	HomeView      *html_views.HomeView
}

func (this *HomeAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.HomeMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.HomeAppBinder.Bind(c, in, c)
	out, errMae := this.HomeMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.HomeView.H(out)
	}, &out.Extra)
	return in, out
}
func (this *HomeAppRoute) GetRoutePath() string {
	return ""
}
func (this *HomeAppRoute) GetMethod() string {
	return "GET"
}
