package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type InstructPlannerAppRoute struct {
	AppRoute                 *route.AppRoute
	AppUrler                 *urlers.AppUrler
	InstructPlannerAppBinder *binders.InstructPlannerAppBinder
	InstructPlannerMae       *mae.InstructPlannerMae
}

func (this *InstructPlannerAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.InstructPlannerMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.InstructPlannerAppBinder.Bind(c, in, c)
	out, errMae := this.InstructPlannerMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	// Composite json based on ids
	//this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.Home())
	return in, out
}
func (this *InstructPlannerAppRoute) GetRoutePath() string {
	return "instruct-planner"
}
func (this *InstructPlannerAppRoute) GetMethod() string {
	return "POST"
}
