package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListGardenTasksAppRoute struct {
	AppRoute                 *route.AppRoute
	AppUrler                 *urlers.AppUrler
	ListGardenTasksAppBinder *binders.ListGardenTasksAppBinder
	ListGardenTasksMae       *mae.ListGardenTasksMae
	ListGardenTasksView      *html_views.ListGardenTasksView
	Logger                   *logger.Logger
}

func (this *ListGardenTasksAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ListGardenTasksMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	err := this.ListGardenTasksAppBinder.Bind(c, in, c)
	if err != nil {
		c.AbortWithError(401, err)
		return in, &maes.ListGardenTasksMaeOut{}
	}
	out, errMae := this.ListGardenTasksMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ListGardenTasksView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ListGardenTasksAppRoute) GetRoutePath() string {
	return "list-garden-tasks"
}
func (this *ListGardenTasksAppRoute) GetMethod() string {
	return "GET"
}
