package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListGardensAppRoute struct {
	AppRoute             *route.AppRoute
	AppUrler             *urlers.AppUrler
	ListGardensAppBinder *binders.ListGardensAppBinder
	ListGardensMae       *mae.ListGardensMae
	ListGardensView      *html_views.ListGardensView
	Logger               *logger.Logger
}

func (this *ListGardensAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ListGardensMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	err := this.ListGardensAppBinder.Bind(c, in, c)
	if err != nil {
		c.AbortWithError(401, err)
		return in, &maes.ListGardensMaeOut{}
	}
	out, errMae := this.ListGardensMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ListGardensView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ListGardensAppRoute) GetRoutePath() string {
	return "list-gardens"
}
func (this *ListGardensAppRoute) GetMethod() string {
	return "GET"
}
