package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListPlantTasksAppRoute struct {
	AppRoute                *route.AppRoute
	AppUrler                *urlers.AppUrler
	ListPlantTasksAppBinder *binders.ListPlantTasksAppBinder
	ListPlantTasksMae       *mae.ListPlantTasksMae
	ListPlantTasksView      *html_views.ListPlantTasksView
	Logger                  *logger.Logger
}

func (this *ListPlantTasksAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ListPlantTasksMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	err := this.ListPlantTasksAppBinder.Bind(c, in, c)
	if err != nil {
		c.AbortWithError(401, err)
		return in, &maes.ListPlantTasksMaeOut{}
	}
	out, errMae := this.ListPlantTasksMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ListPlantTasksView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ListPlantTasksAppRoute) GetRoutePath() string {
	return "list-plant-tasks"
}
func (this *ListPlantTasksAppRoute) GetMethod() string {
	return "GET"
}
