package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListPlantationsAppRoute struct {
	AppRoute                 *route.AppRoute
	AppUrler                 *urlers.AppUrler
	ListPlantationsAppBinder *binders.ListPlantationsAppBinder
	ListPlantationsMae       *mae.ListPlantationsMae
	ListPlantationsView      *html_views.ListPlantationsView
	Logger                   *logger.Logger
}

func (this *ListPlantationsAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ListPlantationsMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	err := this.ListPlantationsAppBinder.Bind(c, in, c)
	if err != nil {
		c.AbortWithError(401, err)
		return in, &maes.ListPlantationsMaeOut{}
	}
	out, errMae := this.ListPlantationsMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ListPlantationsView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ListPlantationsAppRoute) GetRoutePath() string {
	return "list-plantations"
}
func (this *ListPlantationsAppRoute) GetMethod() string {
	return "GET"
}
