package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListPlantsAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	ListPlantsAppBinder *binders.ListPlantsAppBinder
	ListPlantsMae       *mae.ListPlantsMae
	ListPlantsView      *html_views.ListPlantsView
	Logger              *logger.Logger
}

func (this *ListPlantsAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ListPlantsMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	err := this.ListPlantsAppBinder.Bind(c, in, c)
	if err != nil {
		c.AbortWithError(401, err)
		return in, &maes.ListPlantsMaeOut{}
	}
	out, errMae := this.ListPlantsMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ListPlantsView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ListPlantsAppRoute) GetRoutePath() string {
	return "list-plants"
}
func (this *ListPlantsAppRoute) GetMethod() string {
	return "GET"
}
