package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListSeedProgramsAppRoute struct {
	AppRoute                  *route.AppRoute
	AppUrler                  *urlers.AppUrler
	ListSeedProgramsAppBinder *binders.ListSeedProgramsAppBinder
	ListSeedProgramsMae       *mae.ListSeedProgramsMae
	ListSeedProgramsView      *html_views.ListSeedProgramsView
	Logger                    *logger.Logger
}

func (this *ListSeedProgramsAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ListSeedProgramsMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	err := this.ListSeedProgramsAppBinder.Bind(c, in, c)
	if err != nil {
		c.AbortWithError(401, err)
		return in, &maes.ListSeedProgramsMaeOut{}
	}
	out, errMae := this.ListSeedProgramsMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ListSeedProgramsView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ListSeedProgramsAppRoute) GetRoutePath() string {
	return "list-seed-programs"
}
func (this *ListSeedProgramsAppRoute) GetMethod() string {
	return "GET"
}
