package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ListUsersAppRoute struct {
	AppRoute           *route.AppRoute
	AppUrler           *urlers.AppUrler
	ListUsersAppBinder *binders.ListUsersAppBinder
	ListUsersMae       *mae.ListUsersMae
	ListUsersView      *html_views.ListUsersView
	Logger             *logger.Logger
}

func (this *ListUsersAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ListUsersMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	err := this.ListUsersAppBinder.Bind(c, in, c)
	if err != nil {
		c.AbortWithError(401, err)
		return in, &maes.ListUsersMaeOut{}
	}
	out, errMae := this.ListUsersMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ListUsersView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ListUsersAppRoute) GetRoutePath() string {
	return "list-users"
}
func (this *ListUsersAppRoute) GetMethod() string {
	return "GET"
}
