package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewGardenAppRoute struct {
	AppRoute           *route.AppRoute
	AppUrler           *urlers.AppUrler
	Logger             *logger.Logger
	NewGardenAppBinder *binders.NewGardenAppBinder
	NewGardenMae       *mae.NewGardenMae
	NewGardenView      *html_views.NewGardenView
}

func (this *NewGardenAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.NewGardenMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.NewGardenAppBinder.Bind(c, in, c)
	out, errMae := this.NewGardenMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.NewGardenView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *NewGardenAppRoute) GetRoutePath() string {
	return "new-garden"
}
func (this *NewGardenAppRoute) GetMethod() string {
	return "GET"
}
