package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewGardenTaskAppRoute struct {
	AppRoute               *route.AppRoute
	AppUrler               *urlers.AppUrler
	Logger                 *logger.Logger
	NewGardenTaskAppBinder *binders.NewGardenTaskAppBinder
	NewGardenTaskMae       *mae.NewGardenTaskMae
	NewGardenTaskView      *html_views.NewGardenTaskView
}

func (this *NewGardenTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.NewGardenTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.NewGardenTaskAppBinder.Bind(c, in, c)
	out, errMae := this.NewGardenTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.NewGardenTaskView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *NewGardenTaskAppRoute) GetRoutePath() string {
	return "new-garden-task"
}
func (this *NewGardenTaskAppRoute) GetMethod() string {
	return "GET"
}
