package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewPlantAppRoute struct {
	AppRoute          *route.AppRoute
	AppUrler          *urlers.AppUrler
	Logger            *logger.Logger
	NewPlantAppBinder *binders.NewPlantAppBinder
	NewPlantMae       *mae.NewPlantMae
	NewPlantView      *html_views.NewPlantView
}

func (this *NewPlantAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.NewPlantMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.NewPlantAppBinder.Bind(c, in, c)
	out, errMae := this.NewPlantMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.NewPlantView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *NewPlantAppRoute) GetRoutePath() string {
	return "new-plant"
}
func (this *NewPlantAppRoute) GetMethod() string {
	return "GET"
}
