package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewPlantTaskAppRoute struct {
	AppRoute              *route.AppRoute
	AppUrler              *urlers.AppUrler
	Logger                *logger.Logger
	NewPlantTaskAppBinder *binders.NewPlantTaskAppBinder
	NewPlantTaskMae       *mae.NewPlantTaskMae
	NewPlantTaskView      *html_views.NewPlantTaskView
}

func (this *NewPlantTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.NewPlantTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.NewPlantTaskAppBinder.Bind(c, in, c)
	out, errMae := this.NewPlantTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.NewPlantTaskView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *NewPlantTaskAppRoute) GetRoutePath() string {
	return "new-plant-task"
}
func (this *NewPlantTaskAppRoute) GetMethod() string {
	return "GET"
}
