package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewPlantationAppRoute struct {
	AppRoute               *route.AppRoute
	AppUrler               *urlers.AppUrler
	Logger                 *logger.Logger
	NewPlantationAppBinder *binders.NewPlantationAppBinder
	NewPlantationMae       *mae.NewPlantationMae
	NewPlantationView      *html_views.NewPlantationView
}

func (this *NewPlantationAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.NewPlantationMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.NewPlantationAppBinder.Bind(c, in, c)
	out, errMae := this.NewPlantationMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.NewPlantationView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *NewPlantationAppRoute) GetRoutePath() string {
	return "new-plantation"
}
func (this *NewPlantationAppRoute) GetMethod() string {
	return "GET"
}
