package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewSeedProgramAppRoute struct {
	AppRoute                *route.AppRoute
	AppUrler                *urlers.AppUrler
	Logger                  *logger.Logger
	NewSeedProgramAppBinder *binders.NewSeedProgramAppBinder
	NewSeedProgramMae       *mae.NewSeedProgramMae
	NewSeedProgramView      *html_views.NewSeedProgramView
}

func (this *NewSeedProgramAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.NewSeedProgramMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.NewSeedProgramAppBinder.Bind(c, in, c)
	out, errMae := this.NewSeedProgramMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.NewSeedProgramView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *NewSeedProgramAppRoute) GetRoutePath() string {
	return "new-seed-program"
}
func (this *NewSeedProgramAppRoute) GetMethod() string {
	return "GET"
}
