package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type NewUserAppRoute struct {
	AppRoute         *route.AppRoute
	AppUrler         *urlers.AppUrler
	Logger           *logger.Logger
	NewUserAppBinder *binders.NewUserAppBinder
	NewUserMae       *mae.NewUserMae
	NewUserView      *html_views.NewUserView
}

func (this *NewUserAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.NewUserMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.NewUserAppBinder.Bind(c, in, c)
	out, errMae := this.NewUserMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.NewUserView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *NewUserAppRoute) GetRoutePath() string {
	return "new-user"
}
func (this *NewUserAppRoute) GetMethod() string {
	return "GET"
}
