package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type OverviewStorageAppRoute struct {
	AppRoute                 *route.AppRoute
	AppUrler                 *urlers.AppUrler
	OverviewStorageAppBinder *binders.OverviewStorageAppBinder
	OverviewStorageMae       *mae.OverviewStorageMae
	OverviewStorageView      *html_views.OverviewStorageView
}

func (this *OverviewStorageAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.OverviewStorageMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.OverviewStorageAppBinder.Bind(c, in, c)
	out, errMae := this.OverviewStorageMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.OverviewStorageView.H(out)
	}, &out.Extra)
	return in, out
}
func (this *OverviewStorageAppRoute) GetRoutePath() string {
	return "overview-storage"
}
func (this *OverviewStorageAppRoute) GetMethod() string {
	return "GET"
}
