package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type PerformAnalyseAppRoute struct {
	AppRoute                *route.AppRoute
	AppUrler                *urlers.AppUrler
	PerformAnalyseAppBinder *binders.PerformAnalyseAppBinder
	PerformAnalyseMae       *mae.PerformAnalyseMae
}

func (this *PerformAnalyseAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.PerformAnalyseMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.PerformAnalyseAppBinder.Bind(c, in, c)
	out, err := this.PerformAnalyseMae.Act(c, in)
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.Home())
	return in, out
}
func (this *PerformAnalyseAppRoute) GetRoutePath() string {
	return "perform-analyse"
}
func (this *PerformAnalyseAppRoute) GetMethod() string {
	return "POST"
}
