package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
)

type PerformImagesRoutineAppRoute struct {
	AppRoute                      *route.AppRoute
	AppUrler                      *urlers.AppUrler
	PerformImagesRoutineAppBinder *binders.PerformImagesRoutineAppBinder
	PerformImagesRoutineMae       *mae.PerformImagesRoutineMae
}

func (this *PerformImagesRoutineAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.PerformImagesRoutineMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.PerformImagesRoutineAppBinder.Bind(c, in, c)
	out, err := this.PerformImagesRoutineMae.Act(c, in)
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.Home())
	return in, out
}
func (this *PerformImagesRoutineAppRoute) GetRoutePath() string {
	return "perform-images-routine"
}
func (this *PerformImagesRoutineAppRoute) GetMethod() string {
	return "POST"
}
