package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PerformRenewOrdersAppRoute struct {
	AppRoute                    *route.AppRoute
	AppUrler                    *urlers.AppUrler
	PerformRenewOrdersAppBinder *binders.PerformRenewOrdersAppBinder
	PerformRenewOrdersMae       *mae.PerformRenewOrdersMae
	SeeRenewOrdersView          *html_views.SeeRenewOrdersView
}

func (this *PerformRenewOrdersAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.PerformRenewOrdersMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.PerformRenewOrdersAppBinder.Bind(c, in, c)
	out, err := this.PerformRenewOrdersMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.SeeRenewOrdersView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.Home())
	return in, out
}
func (this *PerformRenewOrdersAppRoute) convertOut(out *maes.PerformRenewOrdersMaeOut) *maes.SeeRenewOrdersMaeOut {
	return &maes.SeeRenewOrdersMaeOut{
		In: &maes.SeeRenewOrdersMaeIn{
			Request: maes.SeeRenewOrdersMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.SeeRenewOrdersMaeOutRes{
			FormScope: out.Response.FormScope,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *PerformRenewOrdersAppRoute) GetRoutePath() string {
	return "perform-renew-orders"
}
func (this *PerformRenewOrdersAppRoute) GetMethod() string {
	return "POST"
}
