package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeeEventsAppRoute struct {
	AppRoute           *route.AppRoute
	AppUrler           *urlers.AppUrler
	Logger             *logger.Logger
	SeeEventsAppBinder *binders.SeeEventsAppBinder
	SeeEventsMae       *mae.SeeEventsMae
	SeeEventsView      *html_views.SeeEventsView
}

func (this *SeeEventsAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.SeeEventsMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.SeeEventsAppBinder.Bind(c, in, c)
	out, errMae := this.SeeEventsMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.SeeEventsView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *SeeEventsAppRoute) GetRoutePath() string {
	return "see-events"
}
func (this *SeeEventsAppRoute) GetMethod() string {
	return "GET"
}
