package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeePlannerAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	Logger              *logger.Logger
	SeePlannerAppBinder *binders.SeePlannerAppBinder
	SeePlannerMae       *mae.SeePlannerMae
	SeePlannerView      *html_views.SeePlannerView
}

func (this *SeePlannerAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.SeePlannerMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.SeePlannerAppBinder.Bind(c, in, c)
	out, errMae := this.SeePlannerMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.SeePlannerView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *SeePlannerAppRoute) GetRoutePath() string {
	return "see-planner"
}
func (this *SeePlannerAppRoute) GetMethod() string {
	return "GET"
}
