package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeeRenewOrdersAppRoute struct {
	AppRoute                *route.AppRoute
	AppUrler                *urlers.AppUrler
	Logger                  *logger.Logger
	SeeRenewOrdersAppBinder *binders.SeeRenewOrdersAppBinder
	SeeRenewOrdersMae       *mae.SeeRenewOrdersMae
	SeeRenewOrdersView      *html_views.SeeRenewOrdersView
}

func (this *SeeRenewOrdersAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.SeeRenewOrdersMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.SeeRenewOrdersAppBinder.Bind(c, in, c)
	out, errMae := this.SeeRenewOrdersMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.SeeRenewOrdersView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *SeeRenewOrdersAppRoute) GetRoutePath() string {
	return "see-renew-orders"
}
func (this *SeeRenewOrdersAppRoute) GetMethod() string {
	return "GET"
}
