package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowGardenAppRoute struct {
	AppRoute       *route.AppRoute
	AppUrler       *urlers.AppUrler
	Logger         *logger.Logger
	ShowGardenMae  *mae.ShowGardenMae
	ShowGardenView *html_views.ShowGardenView
}

func (this *ShowGardenAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ShowGardenMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.ShowGardenMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ShowGardenView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ShowGardenAppRoute) GetRoutePath() string {
	return "show-garden"
}
func (this *ShowGardenAppRoute) GetMethod() string {
	return "GET"
}
