package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowGardenTaskAppRoute struct {
	AppRoute           *route.AppRoute
	AppUrler           *urlers.AppUrler
	Logger             *logger.Logger
	ShowGardenTaskMae  *mae.ShowGardenTaskMae
	ShowGardenTaskView *html_views.ShowGardenTaskView
}

func (this *ShowGardenTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ShowGardenTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.ShowGardenTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ShowGardenTaskView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ShowGardenTaskAppRoute) GetRoutePath() string {
	return "show-garden-task"
}
func (this *ShowGardenTaskAppRoute) GetMethod() string {
	return "GET"
}
