package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowPlantAppRoute struct {
	AppRoute      *route.AppRoute
	AppUrler      *urlers.AppUrler
	Logger        *logger.Logger
	ShowPlantMae  *mae.ShowPlantMae
	ShowPlantView *html_views.ShowPlantView
}

func (this *ShowPlantAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ShowPlantMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.ShowPlantMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ShowPlantView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ShowPlantAppRoute) GetRoutePath() string {
	return "show-plant"
}
func (this *ShowPlantAppRoute) GetMethod() string {
	return "GET"
}
