package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowPlantTaskAppRoute struct {
	AppRoute          *route.AppRoute
	AppUrler          *urlers.AppUrler
	Logger            *logger.Logger
	ShowPlantTaskMae  *mae.ShowPlantTaskMae
	ShowPlantTaskView *html_views.ShowPlantTaskView
}

func (this *ShowPlantTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ShowPlantTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.ShowPlantTaskMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ShowPlantTaskView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ShowPlantTaskAppRoute) GetRoutePath() string {
	return "show-plant-task"
}
func (this *ShowPlantTaskAppRoute) GetMethod() string {
	return "GET"
}
