package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowPlantationAppRoute struct {
	AppRoute           *route.AppRoute
	AppUrler           *urlers.AppUrler
	Logger             *logger.Logger
	ShowPlantationMae  *mae.ShowPlantationMae
	ShowPlantationView *html_views.ShowPlantationView
}

func (this *ShowPlantationAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ShowPlantationMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.ShowPlantationMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ShowPlantationView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ShowPlantationAppRoute) GetRoutePath() string {
	return "show-plantation"
}
func (this *ShowPlantationAppRoute) GetMethod() string {
	return "GET"
}
