package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/logger"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type ShowSeedProgramAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	Logger              *logger.Logger
	ShowSeedProgramMae  *mae.ShowSeedProgramMae
	ShowSeedProgramView *html_views.ShowSeedProgramView
}

func (this *ShowSeedProgramAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.ShowSeedProgramMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	in.Request.Id = this.AppRoute.GetId(c)
	out, errMae := this.ShowSeedProgramMae.Act(c, in)
	if errMae != nil {
		panic(errMae)
	}
	this.AppRoute.RenderView(c, func() goc.HTML {
		return this.ShowSeedProgramView.H(out)
	}, &out.Extra)
	this.Logger.LogRoute(c)
	return in, out
}
func (this *ShowSeedProgramAppRoute) GetRoutePath() string {
	return "show-seed-program"
}
func (this *ShowSeedProgramAppRoute) GetMethod() string {
	return "GET"
}
