package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdateGardenAppRoute struct {
	AppRoute              *route.AppRoute
	AppUrler              *urlers.AppUrler
	EditGardenView        *html_views.EditGardenView
	UpdateGardenAppBinder *binders.UpdateGardenAppBinder
	UpdateGardenMae       *mae.UpdateGardenMae
}

func (this *UpdateGardenAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.UpdateGardenMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.UpdateGardenAppBinder.Bind(c, in, c)
	out, err := this.UpdateGardenMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.EditGardenView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowGarden(out.Response.Garden.Id))
	return in, out
}
func (this *UpdateGardenAppRoute) convertOut(out *maes.UpdateGardenMaeOut) *maes.EditGardenMaeOut {
	return &maes.EditGardenMaeOut{
		In: &maes.EditGardenMaeIn{
			Request: maes.EditGardenMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.EditGardenMaeOutRes{
			FormFields: out.Response.FormFields,
			FormBag:    out.Response.FormBag,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *UpdateGardenAppRoute) GetRoutePath() string {
	return "update-garden"
}
func (this *UpdateGardenAppRoute) GetMethod() string {
	return "POST"
}
