package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdateGardenTaskAppRoute struct {
	AppRoute                  *route.AppRoute
	AppUrler                  *urlers.AppUrler
	EditGardenTaskView        *html_views.EditGardenTaskView
	UpdateGardenTaskAppBinder *binders.UpdateGardenTaskAppBinder
	UpdateGardenTaskMae       *mae.UpdateGardenTaskMae
}

func (this *UpdateGardenTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.UpdateGardenTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.UpdateGardenTaskAppBinder.Bind(c, in, c)
	out, err := this.UpdateGardenTaskMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.EditGardenTaskView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowGardenTask(out.Response.GardenTask.Id))
	return in, out
}
func (this *UpdateGardenTaskAppRoute) convertOut(out *maes.UpdateGardenTaskMaeOut) *maes.EditGardenTaskMaeOut {
	return &maes.EditGardenTaskMaeOut{
		In: &maes.EditGardenTaskMaeIn{
			Request: maes.EditGardenTaskMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.EditGardenTaskMaeOutRes{
			FormFields: out.Response.FormFields,
			FormBag:    out.Response.FormBag,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *UpdateGardenTaskAppRoute) GetRoutePath() string {
	return "update-garden-task"
}
func (this *UpdateGardenTaskAppRoute) GetMethod() string {
	return "POST"
}
