package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdatePlantAppRoute struct {
	AppRoute             *route.AppRoute
	AppUrler             *urlers.AppUrler
	EditPlantView        *html_views.EditPlantView
	UpdatePlantAppBinder *binders.UpdatePlantAppBinder
	UpdatePlantMae       *mae.UpdatePlantMae
}

func (this *UpdatePlantAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.UpdatePlantMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.UpdatePlantAppBinder.Bind(c, in, c)
	out, err := this.UpdatePlantMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.EditPlantView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowPlant(out.Response.Plant.Id))
	return in, out
}
func (this *UpdatePlantAppRoute) convertOut(out *maes.UpdatePlantMaeOut) *maes.EditPlantMaeOut {
	return &maes.EditPlantMaeOut{
		In: &maes.EditPlantMaeIn{
			Request: maes.EditPlantMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.EditPlantMaeOutRes{
			FormFields: out.Response.FormFields,
			FormBag:    out.Response.FormBag,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *UpdatePlantAppRoute) GetRoutePath() string {
	return "update-plant"
}
func (this *UpdatePlantAppRoute) GetMethod() string {
	return "POST"
}
