package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdatePlantTaskAppRoute struct {
	AppRoute                 *route.AppRoute
	AppUrler                 *urlers.AppUrler
	EditPlantTaskView        *html_views.EditPlantTaskView
	UpdatePlantTaskAppBinder *binders.UpdatePlantTaskAppBinder
	UpdatePlantTaskMae       *mae.UpdatePlantTaskMae
}

func (this *UpdatePlantTaskAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.UpdatePlantTaskMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.UpdatePlantTaskAppBinder.Bind(c, in, c)
	out, err := this.UpdatePlantTaskMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.EditPlantTaskView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowPlantTask(out.Response.PlantTask.Id))
	return in, out
}
func (this *UpdatePlantTaskAppRoute) convertOut(out *maes.UpdatePlantTaskMaeOut) *maes.EditPlantTaskMaeOut {
	return &maes.EditPlantTaskMaeOut{
		In: &maes.EditPlantTaskMaeIn{
			Request: maes.EditPlantTaskMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.EditPlantTaskMaeOutRes{
			FormFields: out.Response.FormFields,
			FormBag:    out.Response.FormBag,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *UpdatePlantTaskAppRoute) GetRoutePath() string {
	return "update-plant-task"
}
func (this *UpdatePlantTaskAppRoute) GetMethod() string {
	return "POST"
}
