package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdatePlantationAppRoute struct {
	AppRoute                  *route.AppRoute
	AppUrler                  *urlers.AppUrler
	EditPlantationView        *html_views.EditPlantationView
	UpdatePlantationAppBinder *binders.UpdatePlantationAppBinder
	UpdatePlantationMae       *mae.UpdatePlantationMae
}

func (this *UpdatePlantationAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.UpdatePlantationMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.UpdatePlantationAppBinder.Bind(c, in, c)
	out, err := this.UpdatePlantationMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.EditPlantationView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowPlantation(out.Response.Plantation.Id))
	return in, out
}
func (this *UpdatePlantationAppRoute) convertOut(out *maes.UpdatePlantationMaeOut) *maes.EditPlantationMaeOut {
	return &maes.EditPlantationMaeOut{
		In: &maes.EditPlantationMaeIn{
			Request: maes.EditPlantationMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.EditPlantationMaeOutRes{
			FormFields: out.Response.FormFields,
			FormBag:    out.Response.FormBag,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *UpdatePlantationAppRoute) GetRoutePath() string {
	return "update-plantation"
}
func (this *UpdatePlantationAppRoute) GetMethod() string {
	return "POST"
}
