package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdateSeedProgramAppRoute struct {
	AppRoute                   *route.AppRoute
	AppUrler                   *urlers.AppUrler
	EditSeedProgramView        *html_views.EditSeedProgramView
	UpdateSeedProgramAppBinder *binders.UpdateSeedProgramAppBinder
	UpdateSeedProgramMae       *mae.UpdateSeedProgramMae
}

func (this *UpdateSeedProgramAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.UpdateSeedProgramMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.UpdateSeedProgramAppBinder.Bind(c, in, c)
	out, err := this.UpdateSeedProgramMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.EditSeedProgramView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowSeedProgram(out.Response.SeedProgram.Id))
	return in, out
}
func (this *UpdateSeedProgramAppRoute) convertOut(out *maes.UpdateSeedProgramMaeOut) *maes.EditSeedProgramMaeOut {
	return &maes.EditSeedProgramMaeOut{
		In: &maes.EditSeedProgramMaeIn{
			Request: maes.EditSeedProgramMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.EditSeedProgramMaeOutRes{
			FormFields: out.Response.FormFields,
			FormBag:    out.Response.FormBag,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *UpdateSeedProgramAppRoute) GetRoutePath() string {
	return "update-seed-program"
}
func (this *UpdateSeedProgramAppRoute) GetMethod() string {
	return "POST"
}
