package routes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/route"
	"gardening/src/mae"
	"gardening/src/srv/binders"
	"gardening/src/srv/html_views"
	"gardening/src/srv/urlers"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdateUserAppRoute struct {
	AppRoute            *route.AppRoute
	AppUrler            *urlers.AppUrler
	EditUserView        *html_views.EditUserView
	UpdateUserAppBinder *binders.UpdateUserAppBinder
	UpdateUserMae       *mae.UpdateUserMae
}

func (this *UpdateUserAppRoute) Act(c *gin.Context) (maestro.MaeIn, maestro.MaeOut) {
	in := &maes.UpdateUserMaeIn{}
	this.AppRoute.PopulateInContext(c, &in.Context)
	this.UpdateUserAppBinder.Bind(c, in, c)
	out, err := this.UpdateUserMae.Act(c, in)
	if err != nil && this.AppRoute.CanRenderView(err) {
		this.AppRoute.RenderView(c, func() goc.HTML {
			return this.EditUserView.H(this.convertOut(out))
		}, &out.Extra)
		return in, out
	}
	if err != nil {
		this.AppRoute.RenderError(c, err)
		return in, out
	}
	this.AppRoute.SaveMessagesIntoSession(c, out.Extra.Messages)
	this.AppRoute.Redirect(c, &out.Extra, this.AppUrler.ShowUser(out.Response.User.Id))
	return in, out
}
func (this *UpdateUserAppRoute) convertOut(out *maes.UpdateUserMaeOut) *maes.EditUserMaeOut {
	return &maes.EditUserMaeOut{
		In: &maes.EditUserMaeIn{
			Request: maes.EditUserMaeInReq{
				Form: out.In.Request.Form,
			},
			Context: out.In.Context,
		},
		Response: maes.EditUserMaeOutRes{
			FormFields: out.Response.FormFields,
			FormBag:    out.Response.FormBag,
		},
		Success: out.Success,
		Extra:   out.Extra,
		Ctx:     out.Ctx,
	}
}
func (this *UpdateUserAppRoute) GetRoutePath() string {
	return "update-user"
}
func (this *UpdateUserAppRoute) GetMethod() string {
	return "POST"
}
