package routes

// |@@| C

import (
	"gardening/src/lib/kit"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/route"
	"gardening/src/srv/layouts"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
	u "gitlab.com/ccyrillee/kitcla/goc_utils"
)

type AppLoginMiscRoute struct {
	AppRoute    *route.AppRoute
	EmptyLayout *layouts.EmptyLayout
	Kit         *kit.Kit
}

func (this *AppLoginMiscRoute) Act(c *gin.Context) {
	content := goc.H("div",
		goc.Attr{"class": "flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8"},
		u.Wrap("mb-4 mt-8 xl:mt-56", this.Kit.Atoms.Headers.Header.H1("Login")),
		u.Cas("form", goc.Attr{"method": "post", "action": "/auth/login", "class": "flex flex-col space-y-2"},
			this.Kit.Atoms.Inputs.TextInput.TextInput("username", "admin"),
			this.Kit.Atoms.Inputs.TextInput.TextInput("password", "admin"),
			u.Cav("button", goc.Attr{"type": "submit", "class": "bg-primary-1 text-scale-0 py-2 rounded"}, "Login"),
		),
	)
	body := goc.H(
		"body",
		goc.Attr{"class": "theme-light bg-gray-50"},
		content,
	)
	extra := &out_extra.OutExtra{}
	h := this.EmptyLayout.H(body)
	this.AppRoute.RenderView(c, func() goc.HTML {
		return h
	}, extra)
}
