package routes

// |@@| C

import (
	"gardening/src/lib/kit"
	"gardening/src/lib/op"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/route"
	"gardening/src/srv/layouts"
	"github.com/gin-gonic/gin"
	"gitlab.com/ccyrillee/kitcla/goc"
	u "gitlab.com/ccyrillee/kitcla/goc_utils"
	"strings"
)

type DisplayOpMiscRoute struct {
	AppRoute    *route.AppRoute
	EmptyLayout *layouts.EmptyLayout
	Kit         *kit.Kit
	OpStore     *op.OpStore
}

func (this *DisplayOpMiscRoute) Act(c *gin.Context) {
	id := c.Query("id")

	operation := this.OpStore.GetOp(id)

	s := "<script>\n\t\t\tfunction pollOperationStatus() {\n\t\t\t\tfetch('/follow-op?id=__ID__')\n\t\t\t\t\t.then(response => response.json())\n\t\t\t\t\t.then(data => {\n\t\t\t\t\t\tif (data.completed) {\n\t\t\t\t\t\t\tif (data.redirect) {\n\t\t\t\t\t\t\t\twindow.location.href = data.redirect;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tsetTimeout(pollOperationStatus, 100); // Poll every 100 ms\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t\t.catch(error => console.error('Error polling operation status:', error));\n\t\t\t}\n\t\t\tdocument.addEventListener('DOMContentLoaded', pollOperationStatus);\n\t\t</script>"
	s = strings.Replace(s, "__ID__", operation.Id, 1)

	content := goc.H("div",
		goc.Attr{"class": "flex flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8"},
		this.loadingAnimation(operation),
		u.ExpHtml(s),
	)
	body := goc.H(
		"body",
		goc.Attr{"class": "theme-light bg-gray-50"},
		content,
	)
	extra := &out_extra.OutExtra{}
	h := this.EmptyLayout.H(body)
	this.AppRoute.RenderView(c, func() goc.HTML {
		return h
	}, extra)
}
func (this *DisplayOpMiscRoute) loadingAnimation(operation *op.Op) goc.HTML {
	return goc.H("div",
		goc.Attr{"class": "flex items-center justify-center space-x-2 mt-8"},
		goc.H("style", "/* Keyframes for the bounce animation */\n            @keyframes bounce {\n                0%, 100% {\n                    transform: translateY(0);\n                }\n                50% {\n                    transform: translateY(-10px);\n                }\n            }\n            /* Styling for the spinner dots */\n            .spinner-dot {\n                width: 12px;\n                height: 12px;\n                background-color: #3B82F6; /* Tailwind blue-500 */\n                border-radius: 50%;\n                animation: bounce 0.6s infinite alternate;\n            }\n            /* Delay animation for each dot */\n            .spinner-dot:nth-child(2) {\n                animation-delay: 0.1s;\n            }\n            .spinner-dot:nth-child(3) {\n                animation-delay: 0.2s;\n            }"),
		this.Kit.Component.Dcs("flex flex-col space-y-8 items-center",
			goc.H("p", goc.Attr{"class": "text-lg text-gray-700"}, operation.Title),
			this.animation(),
		),
	)
}
func (this *DisplayOpMiscRoute) animation() goc.HTML {
	return this.Kit.Component.Dcs("flex flex-row space-x-1",
		goc.H("div", goc.Attr{"class": "spinner-dot"}),
		goc.H("div", goc.Attr{"class": "spinner-dot"}),
		goc.H("div", goc.Attr{"class": "spinner-dot"}),
	)
}
