package routes

// |@@| C

import (
	"gardening/src/lib/message"
	"gardening/src/lib/op"
	"gardening/src/lib/route"
	"github.com/gin-gonic/gin"
	"net/http"
)

type FollowOpMiscRoute struct {
	AppRoute *route.AppRoute
	OpStore  *op.OpStore
}

func (this *FollowOpMiscRoute) Act(c *gin.Context) {
	id := c.Query("id")

	operation := this.OpStore.GetOp(id)

	if operation.Messaged == false && operation.Message.Kind != "" {
		operation.Messaged = true
		this.AppRoute.SaveMessagesIntoSession(c, []*message.Message{&operation.Message})
	}

	c.JSON(http.StatusOK, gin.H{
		"completed":  operation.Completed,
		"success":    operation.Success,
		"started_at": operation.StartedAt,
		"ended_at":   operation.EndedAt,
		"redirect":   operation.Redirect,
	})
}
