package routes

// |@@| C

import (
	"github.com/gin-gonic/gin"
	"os/exec"
	"strings"
)

type OpenFileMiscRoute struct {
}

func (this *OpenFileMiscRoute) Act(c *gin.Context) {
	s := struct {
		Filepath string
	}{}
	c.BindJSON(&s)
	if s.Filepath == "" {
		c.JSON(400, gin.H{"error": "filepath parameter is required"})
		return
	}

	ss := strings.Split(s.Filepath, ":")

	var args []string
	if len(ss) == 2 {
		args = append(args, "--line")
		args = append(args, ss[1])
	}
	args = append(args, ss[0])

	cmd := exec.Command("goland", args...)
	err := cmd.Start()
	if err != nil {
		c.JSON(500, gin.H{"error": "Failed to open file"})
		return
	}
	c.JSON(200, gin.H{"Ok": "File opened in GoLand"})
}
