package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type CreateGardenMaeIn struct {
	Request CreateGardenMaeInReq
	Context in_context.InContext
}

type CreateGardenMaeOut struct {
	In       *CreateGardenMaeIn
	Response CreateGardenMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type CreateGardenMaeInReq struct {
	Form  forms.CreateGardenForm `form:"form"`
	Files CreateGardenMaeFiles   `form:"files"`
}

type CreateGardenMaeOutRes struct {
	Garden     *mdl.Garden
	FormBag    *form.FormBag
	Form       forms.CreateGardenForm
	FormFields []*presenter.FormField
}

type CreateGardenMaeFiles struct {
	Picture string
}
