package maes

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/lib/form"
	"gardening/src/lib/in_context"
	"gardening/src/lib/out_extra"
	"gardening/src/lib/presenter"
	"gardening/src/mdl"
)

type CreateGardenTaskMaeIn struct {
	Request CreateGardenTaskMaeInReq
	Context in_context.InContext
}

type CreateGardenTaskMaeOut struct {
	In       *CreateGardenTaskMaeIn
	Response CreateGardenTaskMaeOutRes
	Success  bool
	Ctx      context.Context
	Extra    out_extra.OutExtra
}

type CreateGardenTaskMaeInReq struct {
	Form forms.CreateGardenTaskForm `form:"form"`
}

type CreateGardenTaskMaeOutRes struct {
	GardenTask *mdl.GardenTask
	FormBag    *form.FormBag
	Form       forms.CreateGardenTaskForm
	FormFields []*presenter.FormField
}
